{smcl}
{* *! version 1.0.0, 24aug2014}{...}
{title:Title}

{phang}
{bf:svarih, cmat} -- display coefficient matrices and matrices of p-values of {cmd:svarih} models


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:coefmat}
{cmd:,} {opt cmat}
[{opt st:ar}
{opt ext:ended}
{opt nop:val}
{opt f:ormat(%fmt)}
{it:method_specific_options}
]


{synoptset 25 tabbed}{...}
{synopthdr:common_options}
{synoptline}
{synopt: {opt st:ar}}show .a, .b, .c p-value encoding instead of actual p-values{p_end}
{synopt: {opt ext:ended}}extend p-value encoding by .d, .e{p_end}
{synopt: {opt nop:val}}do not calculate and display p-value information{p_end}
{synopt: {opt format(%fmt)}}format numbers of all matrices according to {it:%fmt}.{p_end}
{synoptline}

{synoptset 25 tabbed}{...}
{synopthdr:method_specific_options}
{synoptline}

{syntab:{cmd:svarih bacchiocchi}}
{synopt:{opt a}}Display A matrix{p_end}
{synopt:{opt b}}Display B matrix{p_end}
{synopt:{opt e}}Display E matrix{p_end}
{synopt:{opt bp:luse}}Display sum of B and E matrix{p_end}
{synopt:}{p_end}
{synopt:}If none of the above options is specified, the command defaults to option set "a b e"{p_end}

{syntab:{cmd:svarih bfanelli}}
{synopt:{opt b}}Display B matrix{p_end}
{synopt:{opt e#}}Display E matrix for regime {it:#}, with 2 {ul:<} {it:#} {ul:<} 4 and {it:#} {ul:<} number of regimes in the model{p_end}
{synopt:{opt bp:luse(rgmlist)}}Display sum of B and E{it:#} matrix for regimes in {it:rgmlist}{p_end}
{synopt:}{p_end}
{synopt:}If none of the above options is specified, the command defaults to the option "b" and all "e{it:#}" matrices in the model{p_end}

{syntab:{cmd:svarih llutkepohl}}
{synopt:{opt b}}Display B matrix{p_end}
{synopt:{opt l}}Display L matrix (a row vector){p_end}
{synopt:{opt bl}}Display B*Ld^(1/2) matrix, where Ld is a diagonal matrix whose diagonal elements are those of L{p_end}
{synopt:}{p_end}
{synopt:}If none of the above options is specified, the command defaults to option set "b l"{p_end}


{marker description}{...}
{title:Description}

{pstd}
{cmd:svarih, cmat} is a postestimation utility for models estimated by {cmd:svarih}.
Corresponding {cmd:e()-}results must be in memory.

{pstd}
{cmd:svarih, cmat} extends standard estimation replay.
If you omit the option {opt cmat} from your replay statement by typing {cmd:svarih , {it:replay_options}}, replay of {cmd:svarih} models works as with any other Stata estimator.
If you specify the option {opt cmat} in your replay statement by typing {cmd:svarih, cmat {it:cmat_options}}, none of the standard replay options is allowed anymore.
Instead, the options as described in this help file apply.

{pstd}
{cmd:svarih, cmat} does two things:
First, it displays coefficient matrices along with their p-values in matrix form.
Secondly, it calculates linear and nonlinear combinations of model coefficients, and again displays results along with implied p-values in matrix form.
It stores all displayed magnitudes in {cmd:r()}.


{marker option}{...}
{title:Options (common to all svarih models)}

{phang}
{cmd:star} displays a p-value encoding similar to the familiar "star" encoding of "***", "**", "*" corresponding to significance levels of 0.01, 0.05, and 0.1, respectively.
Option {opt star} uses ".a", ".b", ".c" to encode these significance levels.

{phang}
{cmd:extended} extends the p-value encoding to ".d" and ".e" which stand for significance at levels of 0.25 and 0.5, respectively.

{phang}
{cmd:format(%fmt)} formats the elements of the displayed matrices according to display format {it:%fmt}.
See {help format}.
Setting a format that has few digits may shrink the column widths of the output matrices and invoke variable name abbreviations (the column names of the matrices).
If you want to avoid this, supply a large number before the decimal point in {it:%fmt} (e.g. {cmd:format(%12.3f)} instead of {cmd:format(%5.3f)})

{phang}
{cmd:nopval} omits the calculation of p-values.
By default, any coefficient matrix requested is displayed and returned in {cmd:r()} as a "merged" matrix:
p-values are displayed in the row beneath the coefficients.
Default behavior also entails that separate p-values matrices are returned in {cmd:r()}.
Option {opt nopval} skips this.


{marker examples}{...}
{title:Examples}

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples llu_constr_gls , ereplace:. svarih examples llu_constr_gls , ereplace}{p_end}
{phang2}{stata svarih , nocnsreport:. svarih , nocnsreport}{p_end}
{phang2}{stata svarih , cmat:. svarih , cmat}{p_end}
{phang2}{stata svarih , cmat bl format(%12.3f):. svarih , cmat bl format(%12.3f)}{p_end}
{phang2}{stata svarih , cmat bl format(%12.3f) star extended :. svarih , cmat bl format(%12.3f) star extended }{p_end}

{phang2}{stata svarih examples bac_first , ereplace:. svarih examples bac_first , ereplace}{p_end}
{phang2}{stata svarih , nocnsreport notable:. svarih , nocnsreport notable}{p_end}
{phang2}{stata svarih , cmat:. svarih , cmat}{p_end}
{phang2}{stata svarih , cmat b e bpluse:. svarih , cmat b e bpluse}{p_end}
{phang2}{stata return list:. return list}{p_end}
{phang2}{stata matrix list r(E):. matrix list r(E)}{p_end}
{phang2}{stata matrix list r(Ep):. matrix list r(Ep)}{p_end}
{phang2}{stata svarih , cmat e nopval:. svarih , cmat e nopval}{p_end}
{phang2}{stata return list:. return list}{p_end}
{phang2}{stata matrix list r(E):. matrix list r(E)}{p_end}

{marker savedresults}{...}
{title:Saved results}

{pstd}
{cmd:svarih, cmat} saves the following in {cmd:r()}:

{pstd}
All coefficient matrices displayed are returned.
By default, these matrices contain p-values in the row below the coefficients that the p-values refer to.
For each of these matrices, default behavior is to additionally return a corresponding matrix of the same name with the letter "p" appended.
It contains only p-values.
If option {opt nopval} is used, the coefficient matrices returned are pure coefficient matrices, without p-values, and no separate p-value matrices are returned.

{pstd}
The following table lists the matrices available for each model.

{synoptset 14 tabbed}{...}
{p2col 5 14 14 0: svarih method}{p_end}
{synopt:{cmd:bacchiocchi}}A B E BplusE{p_end}
{synopt:{cmd:bfanelli}}B E2 BplusE2{break}
additionally, if the model contains regime 3: E3 BplusE3{break}
additionally, if the model contains regime 4: E4 BplusE4{p_end}
{synopt:{cmd:llutkepohl}}B L BL{p_end}
{p2colreset}{...}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb svar:[TS] svar},
{helpb svarih},
{helpb svarih bac},
{helpb svarih bfa},
{helpb svarih llu},
{helpb svarih postestimation},
{helpb dsimih}
{p_end}

